#!/bin/bash
# Tint2 toolbar quick settings, by PPC
#-------------------------------------------------
# Modified by marcelocripe 12/02/2021 - script prepared for translation

        TEXTDOMAINDIR=/usr/share/locale
        TEXTDOMAIN=ft10_tint2_manager

#Variable names, for easier translation:
window_title=$"Toolbar manager"
quick_launch_icons=$"Add/Remove Icons"
position=$"Toolbar Position"
auto_hide=$"Auto-hide toolbar"
resize=$"Toolbar size"
clock=$"12/24h Clock"
show_titles=$"Show window titles in toolbar"
colors=$"Toolbar and menu color"
fonts=$"Fonts"
show_cpu_ram=$"Show CPU, RAM"
show_network_icon=$"Show network icon"
show_ft10_volume_icon=$"Show FT10 volume icon"
show_usb_ejector=$"Show USB ejector icon"
show_power_button=$"Show Power button"

#Allow only one instance of the script running. the wmctrl part is to toogle window on/off from tint2 toolbar
scriptname=/usr/local/bin/ft10_tint2_manager.sh
for pid in $(pidof -x $scriptname); do
    if [ $pid != $$ ]; then
     wmctrl -c $window_title
        exit 1     
    fi 
done

#Main script
[ ! -f ~/.config/tint2/tint2rc ] && { 
	yad --title="$window_title" --text="~/.config/tint2/tint2rc not found\nRun tint2 at least once" --button='Ok' 
	exit 1
}
window_icon="/usr/share/icons/papirus-antix/22x22/apps/tint2.png"
while yad --window-icon=$window_icon --title="$window_title" --center --form --width=450 \
--field="$quick_launch_icons!/usr/share/icons/papirus-antix/symbolic/actions/view-more-horizontal-symbolic.png":BTN "/usr/local/lib/ft10/tim-tint.sh" \
--field="$position!/usr/share/icons/papirus-antix/48x48/actions/transform-move.png":BTN "/usr/local/lib/ft10/tint2-top-bottom.sh" \
--field="$auto_hide!/usr/share/icons/papirus-antix/48x48/actions/format-align-vertical-bottom.png":BTN "/usr/local/lib/ft10/tint2-toggle-autohide.sh" \
--field="$resize!/usr/share/icons/papirus-antix/symbolic/actions/object-flip-horizontal-symbolic.png":BTN "/usr/local/lib/ft10/tint2_outros.sh" \
--field="$clock!/usr/share/icons/papirus-antix/48x48/actions/view-history.png":BTN  "/usr/local/lib/ft10/tint2-toogle-12-24h.sh" \
--field="$show_titles!/usr/share/icons/papirus-antix/48x48/actions/view-categories.png":BTN "/usr/local/lib/ft10/tint2-toggle-window-titles.sh" \
--field="$colors!/usr/share/icons/papirus-antix/48x48/actions/color-management.png":BTN "/usr/local/lib/ft10/ft10-colors.sh" \
--field="$fonts!/usr/share/icons/papirus-antix/48x48/actions/font-select.png":BTN "/usr/local/lib/ft10/tint2_fonts.sh" --no-buttons \
--field="$show_cpu_ram!/usr/share/icons/papirus-antix/24x24/devices/cpu.png":BTN "/usr/local/lib/ft10/ft10_tint2_toggle-resources.sh" \
--field="$show_network_icon!/usr/share/icons/papirus-antix/24x24/panel/nm-device-wireless.png":BTN "/usr/local/lib/ft10/ft10_tint2_toggle-internet.sh" \
--field="$show_ft10_volume_icon!/usr/share/icons/papirus-antix/48x48/actions/audio-ready.png":BTN "/usr/local/lib/ft10/ft10_tint2_toggle-volume.sh" \
--field="$show_usb_ejector!/usr/share/icons/papirus-antix/48x48/actions/media-eject.png":BTN "/usr/local/lib/ft10/ft10_tint2_toggle-eject.sh" \
--field="$show_power_button!/usr/share/icons/papirus-antix/symbolic/actions/system-shutdown-symbolic.png":BTN "/usr/local/lib/ft10/ft10_tint2_toggle-power.sh"

do
	:
done


fi
