#!/bin/bash

#Allow only one instance of the script running
scriptname="$0"
for pid in $(pidof -x $scriptname); do
    if [ $pid != $$ ]; then
     echo Calendar Alarms are already on.
     wmctrl -c "antiX-calendar"
     exit     
    fi 
done

#Kill all Calendar Windows, just in case the icon that indicates status has to be redrawn
pkill yad-calendar-ft
wmctrl -c "antiX-calendar"

#Display "notification" when calendar alarms are turned on (because the script that manages them does use a tiny bit of system resources)
yad --timeout=2 --on-top --window-icon="/usr/share/icons/papirus-antix/24x24/apps/calendar.png"  --title="antiX Calendar" --picture --filename=/usr/local/lib/ft10/icons/alarms_on-small.png --geometry=300x180-50-50 --inc=256 --no-buttons --timeout-indicator=bottom

               #Make sure that Calendar alarms auto-start after antiX restarts:    
               if grep -xq "^slarm3.sh" ~/.desktop-session/startup; then
				 status="already found the script on startup file, doing nothing"
				else
				 #script not found on startup file, adding it:
				 echo "slarm3.sh &" >> ~/.desktop-session/startup
			   fi

#Main Script:  
while :
do
today=$(date +%x)
today=$(echo \"$today\")
today2=^
today7=$today2${today:1:10}
today=$today7
now=$(date +%H:%M)
current_event_check=$(grep "$today" $HOME/yad-calendar.txt| grep -o $now.*)
    if [ -n "$current_event_check" ]; then
           #echo "There IS an event right now"
		if [ "$now" == "$last_processed_event" ]; then
            status="event already processed"
			else
			echo $now > /tmp/calendar-event-processed.txt
			last_processed_event=$(cat /tmp/calendar-event-processed.txt)
			event_description=$(echo $current_event_check| cut -d\@ -f1)
			title=$(date +%x)
			#Sound alarm and display window with event
			mpv /usr/local/lib/ft10/ahooga-horn-vobis.ogg &	yad --center  --window-icon=calendar --title="$title" --width=300 --text=" $event_description " --button="x"
	   	fi
    fi
    
snore()
{
    local IFS
    [[ -n "${_snore_fd:-}" ]] || { exec {_snore_fd}<> <(:); } 2>/dev/null ||
    {
        # workaround for MacOS and similar systems
        local fifo
        fifo=$(mktemp -u)
        mkfifo -m 700 "$fifo"
        exec {_snore_fd}<>"$fifo"
        rm "$fifo"
    }
    read ${1:+-t "$1"} -u $_snore_fd || :
}
#The "snore" function is a way to avoid getting a sleep process, so "snore 7" is equivalent to "sleep 7"(seconds)
snore 7   

done  
